// Piezo sensor clip for measuring the vibrations at one end of a thin flat piece of wood such as a guitar top.
// Mark Rau, 2020
// mrau@ccrma.stanford.edu
//
//
//
// Use:
// 1. The head fits a Thorlabs PK4DLP1 (https://www.thorlabs.com/thorproduct.cfm?partnumber=PK4DLP1) piezo sensor. It is a snug fit and no adhesive should be needed. 
// 2. The cable can be run through the bottom of the clip.
// 3. A Small wingbolt can be used to hold the clip snuggly to the guitar top. 
// 4. There is 6 mm of clearance in the clip. 
//
//
// Licensed under the Creative Commons - Attribution license.








// piezo housing size
housingX = 4.5;
housingY = 2.8;  


// clip
difference() {
        translate([-2, 0, 0])
        cube([24,10,12],true);
        translate([-7, 0, 0])
        cube([15,10,6],true);
        
        // hole for sensor
        translate([2,0,-1.2])
        cube([4,housingX+0.8,housingY+0.8],true);
    
        // hole for sensor screw
        translate([0,0,-1.2])
        rotate([0,90,0])
        cylinder(h=20, r=1.6);
    
        // holes for sensor wire
        translate([6,1.5,-5])
        rotate([0,315,0])
        cube([3,2,10],true);
    
    
        translate([6,-1.5,-5])
        rotate([0,315,0])
        cube([3,2,10],true);
    
        // hole on top for screw
        translate([-8,0,0])
        rotate([0,0,0])
        cylinder(h=10, r=1.6);
        // hole for sensor
        translate([2,0,-1.2])
        cube([4,housingX+0.8,housingY+0.8],true);
    
        // hole for sensor screw
        translate([0,0,-1.2])
        rotate([0,90,0])
        cylinder(h=20, r=1.6);
    
        // holes for sensor wire
        translate([6,1.5,-5])
        rotate([0,315,0])
        cube([3,2,10],true);
    
    
        translate([6,-1.5,-5])
        rotate([0,315,0])
        cube([3,2,10],true);
    
        // hole on top for screw
        translate([-8,0,0])
        rotate([0,0,0])
        cylinder(h=10, r=1.6);
        
        
    
    
}

