// Force sensing hammer.
// Mark Rau, 2020
// mrau@ccrma.stanford.edu
//
//
//
// Use:
// 1. The head fits a Thorlabs PK4DLP1 (https://www.thorlabs.com/thorproduct.cfm?partnumber=PK4DLP1) piezo sensor. It is a snug fit and no adhesive should be needed. 
// 2. The cable can be run through the center of the hammer shaft.
// 3. The Bottom circle fits a standard skateboard bearing (since they are easy to find), but the size can be altered for a different bearing. 
//
//
// Licensed under the Creative Commons - Attribution license.


armLength = 80;
armDiam = 7.5;

//arm
difference() {
        cylinder(h=armLength, r=armDiam/2,$fn = 100);
        //translate([0, 0, -])
        cylinder(h=armLength, r=armDiam/2-1,$fn = 100);
        
    translate([-3.5,0,10])
    cube([4,4,8],true);
    
    translate([-5,armDiam/2,10])
    cube([10,1,100]);
    
    // take out the bearing circle
    rotate([90,0,0])
    translate([-ballBearingDiam/2,-5,-armDiam/2])
    cylinder(h=armDiam, r=ballBearingDiam/2,$fn = 100);
}

// A couple little side supports where the arm meets the bearing mount
difference(){
    translate([-9,armDiam/2-1,3.5])
    cube([10,1,6]);
    
    rotate([90,0,0])
    translate([-ballBearingDiam/2,-5,-armDiam/2])
    cylinder(h=armDiam, r=ballBearingDiam/2,$fn = 100);
}
difference(){
    translate([-9,-armDiam/2,3.5])
    cube([10,1,6]);

    rotate([90,0,0])
    translate([-ballBearingDiam/2,-5,-armDiam/2])
    cylinder(h=armDiam+2, r=ballBearingDiam/2+0.1,$fn = 100);
}
    
    
housingX = 4.5;
housingY = 2.8;  
housingDepth = 3;
hammerHeadLength = 20;

//head
translate([(hammerHeadLength-armDiam)/2,0,armLength+(housingY+3)/2])
difference(){
   cube([hammerHeadLength,housingX+3,housingY+3],true); 
   cube([hammerHeadLength,housingX,housingY],true);
   translate([-(hammerHeadLength-armDiam)/2-armDiam/4,0,- (housingY+3)/2 + 1])
   cube([armDiam,housingX,2],true);
        
}
    


// head indent to hold sensor in
translate([armDiam-housingDepth+8,0,armLength+(housingY+3)/2])
cube([2,2,housingDepth],true);


ballBearingDiam = 22.1;
ballBearingThickness = 7;


// Bearing mount at bottom
rotate([90,0,0])
translate([-ballBearingDiam/2,-5,-armDiam/2])
difference() {
        cylinder(h=armDiam, r=ballBearingDiam/2+3.5,$fn = 100);
        //translate([0, 0, -])
        cylinder(h=armDiam, r=ballBearingDiam/2+0.1,$fn = 100);
        

}




